 /* basic language like c flex file*/

%{
#include "common.h"
#include "lang.tab.h"
#include <string.h>
#include "error.h"

extern int line_number;

int rem_depth = 0;
%}

%x remarks



%%

 /*zvlastni skupina pravidel pro rozpoznavani komentaru*/
<remarks>
{
\n			line_number++;
"*/"			{rem_depth--; if (!rem_depth) BEGIN(INITIAL);}
"/*"			{rem_depth++;}
"//"[^\n]*		/*ignoruj jednoradkovy komentar*/
<<EOF>>			yyerror("Unclosed Comment!");
[^*/\n]*		/*ignoruj vsechno co neni *, / nebo novy radek*/;
.			/*ignoruj vse ostatni*/

}

[ \t]+			/*ignoruj jeden ci vice vyskytu tabulatoru ci mezery*/
"/*"			{rem_depth++; BEGIN(remarks);};
\n			line_number++;
"//"[^\n]*		/*ingnoruj jednoradkove komentre, tj vsechno co je po // a neni to novy radek*/


if			return tIF;
else			return tELSE;
for			return tFOR;
while			return tWHILE;
function		return tFUNCTION;
return			return tRETURN;
extern			return tEXTERN;
int			return tINT;
string			return tSTRING;
double			return tDOUBLE;
void			return tVOID;
"N/A"			return tNA;


"&&"			return tAND;
"=="			return tEQUALS;
">="			return tGEQUALS;
"<="			return tLEQUALS;
"!="			return tNEQUALS;
"||"			return tOR;
"++"			return tINC;
"--"			return tDEC;
"+="			return tPLUSASSIGN;
"-="			return tMINUSASSIGN;
"*="			return tMULASSIGN;
"/="			return tDIVASSIGN;
"%="			return tMODASSIGN;
"<<="			return tSHLASSIGN;
">>="			return tSHRASSIGN;
"<<"			return tSHL;
">>"			return tSHR;
"&="			return tANDASSIGN;
"|="			return tORASSIGN;
"="			return '=';
">"			return '>';
"<"			return '<';
"!"			return '!';
"+"			return '+';
"-"			return '-';
"*"			return '*';
"/"			return '/';
"%"			return '%';
"{"			return '{';
"}"			return '}';
";"			return ';';
"("			return '(';
")"			return ')';
","			return ',';
"&"			return '&';			//bitovy and
"|"			return '|';			//bitovy or

			/*cisla, povolene je bud nula nebo cisla 1 a neco. Nelze mit cisla 007. Ty jsou nepovolena*/
0|([1-9][0-9]*)		{yylval.intconst = atoi(yytext); return tINTCONST;}

			/* Tohle je pro double cisla. Rika ze to muze byt cislo jako 0.neco, ale ne 000.neco. Nebo
			cislo muze byt jako libovolny pocet cislic 1-9 pred . a libovolny pocet 0-9 za .*/
(0"."[0-9]*)|([1-9]*"."[0-9]*)	{yylval.doubleconst = atof(yytext); return tDOUBLECONST;}

true			{yylval.intconst = 1; return tINTCONST;}

false			{yylval.intconst = 0; return tINTCONST;}

\"[^\"\n]*\"		{yytext[strlen(yytext)-1] = '\0';
			 yylval.stringconst = strdup(yytext + 1);
			 return tSTRINGCONST;}
[A-Za-z_][A-Za-z0-9_]*	{yylval.identifier = strdup(yytext);
			 return tIDENTIFIER; }

.			yyerror("Invalid character '%s'.",yytext);

%%


int	yywrap()
{
	return 1;
}
